TTweet = enchant.Class.create(enchant.Sprite, {
	initialize : function(w, h) {
		this.lifetime = 0;
		enchant.Sprite.call(this, w, h + TTweet.TAIL);
		this.image = new Surface(w, h + TTweet.TAIL);
		var t = TTweet.TAIL;
		var s = TTweet.SIZE;
		var c = TTweet.CURVE;
		this.outCurve = {
			lt : {x:  0, y:  t},
			rt : {x:  w, y:  t},
			rd : {x:  w, y:h+t},
			ld : {x:  0, y:h+t}
		};
		this.inCurve = {
			lt : {x:  0+s, y:  t+s},
			rt : {x:  w-s, y:  t+s},
			rd : {x:  w-s, y:h+t-s},
			ld : {x:  0+s, y:h+t-s}
		};
		this.image.context.font = "12px 'Times New Roman'";
		this.addEventListener('enterframe', function(){
			if((this.age % 15) == 0){
				this.lifetime--;
			}
			if(this.lifetime <= 0){
				this.lifetime = 0;
				this.opacity = 0;
			}
		});
	},
	reDraw : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		with(this.image.context) {
			fillStyle = 'black';
			strokeStyle = 'black';
			beginPath();
			moveTo(o.lt.x, o.lt.y+c);
			quadraticCurveTo(o.lt.x, o.lt.y, o.lt.x+c, o.lt.y);
			lineTo(o.rt.x-c, o.rt.y);
			quadraticCurveTo(o.rt.x, o.rt.y, o.rt.x, o.rt.y+c);
			lineTo(o.rd.x, o.rd.y-c);
			quadraticCurveTo(o.rd.x, o.rd.y, o.rd.x-c, o.rd.y);
			lineTo(o.ld.x+c, o.ld.y);
			quadraticCurveTo(o.ld.x, o.ld.y, o.ld.x, o.ld.y-c);
			// しっぽ
			// var _height = 100;
			// lineTo(this.width/2-4,_height + TTweet.TAIL);
			// lineTo(this.width/2,_height + 0);
			// lineTo(this.width/2+4,_height + TTweet.TAIL);
			closePath();
			fill();
			stroke();
		};
		this.clear();
	},
	clear : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		var i = this.inCurve;
		with(this.image.context) {
			// 抜く
			fillStyle = 'white';
			beginPath();
			moveTo(i.lt.x, o.lt.y+c);
			quadraticCurveTo(i.lt.x, i.lt.y, o.lt.x+c, i.lt.y);
			lineTo(o.rt.x-c, i.rt.y);
			quadraticCurveTo(i.rt.x, i.rt.y, i.rt.x, o.rt.y+c);
			lineTo(i.rd.x, o.rd.y-c);
			quadraticCurveTo(i.rd.x, i.rd.y, o.rd.x-c, i.rd.y);
			lineTo(o.ld.x+c, i.ld.y);
			quadraticCurveTo(i.ld.x, i.ld.y, i.ld.x, o.ld.y-c);
			closePath();
			fill();
		};
	},
	text : function(text, x, y) {
		this.clear();
		this.opacity = 0.8;

		this.reDraw();
		with(this.image.context) {
			// var size = measureText(text);
			fillStyle = 'black';
			textAlign = 'center';
			textBaseline = 'middle';
			this.x = x;
			this.y = y;
			// fillText(text,this.width/2,this.height/2);
			// console.log(size);
			// this.width = size;
			// console.log(this.width);
			// this.reDraw();
			var textList = text.split("\n");
			var len = textList.length / 2;
			var height = (this.height/(1 + len));
			this.fillTextLine(text,this.width/2, height);
		}
		this.lifetime = 7;

	},
	fillTextLine : function(text, x, y) {
		var textList = text.split("\n");
		var lineHeight = this.image.context.measureText("あ").width + 2;
		var self = this;
		textList.forEach(function(text, i) {
			self.image.context.fillText(text, x, y + lineHeight * i);
		});
	},


});
TTweet.TAIL  =  8;
TTweet.SIZE  =  2;
TTweet.CURVE = 16;


var Box = enchant.Class.create(enchant.Sprite, {
	initialize : function(ctl, node, x, y,  w, h) {
		enchant.Sprite.call(this, w, h + TTweet.TAIL);
		this.node = node;
		this.x = x;
		this.y = y;
		//even ObjSprite
		this.id = guid();


		this.ctl = ctl;
		ctl.addObj(this);
		ctl.game.rootScene.addEventListener('touchstart', this.touchstart(this));
		ctl.backgroundMap.addChild(this);


		this.lifetime = 999;
		this.image = new Surface(w, h + TTweet.TAIL);
		var t = TTweet.TAIL;
		var s = TTweet.SIZE;
		var c = TTweet.CURVE;
		this.outCurve = {
			lt : {x:  0, y:  t},
			rt : {x:  w, y:  t},
			rd : {x:  w, y:h+t},
			ld : {x:  0, y:h+t}
		};
		this.inCurve = {
			lt : {x:  0+s, y:  t+s},
			rt : {x:  w-s, y:  t+s},
			rd : {x:  w-s, y:h+t-s},
			ld : {x:  0+s, y:h+t-s}
		};
		this.image.context.font = "12px 'Times New Roman'";
		var self = this;
		this.addEventListener('enterframe', function(){
			if((this.age % BASE_FPS) == 0){
				this.lifetime--;
				this.drawBox();
			}
			if(this.lifetime <= 0){
				this.lifetime = 0;
				this.opacity = 0;
				this.removeEventListener('enterframe', arguments.callee);
				self.release();
			}
		});
	},
	reDraw : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		with(this.image.context) {
			fillStyle = 'black';

			strokeStyle = 'black';
			beginPath();
			moveTo(o.lt.x, o.lt.y+c);
			quadraticCurveTo(o.lt.x, o.lt.y, o.lt.x+c, o.lt.y);
			lineTo(o.rt.x-c, o.rt.y);
			quadraticCurveTo(o.rt.x, o.rt.y, o.rt.x, o.rt.y+c);
			lineTo(o.rd.x, o.rd.y-c);
			quadraticCurveTo(o.rd.x, o.rd.y, o.rd.x-c, o.rd.y);
			lineTo(o.ld.x+c, o.ld.y);
			quadraticCurveTo(o.ld.x, o.ld.y, o.ld.x, o.ld.y-c);
			closePath();
			fill();
			stroke();
		};
		this.clear();
	},
	clear : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		var i = this.inCurve;
		with(this.image.context) {
			// 抜く
			fillStyle = 'white';
			beginPath();
			moveTo(i.lt.x, o.lt.y+c);
			quadraticCurveTo(i.lt.x, i.lt.y, o.lt.x+c, i.lt.y);
			lineTo(o.rt.x-c, i.rt.y);
			quadraticCurveTo(i.rt.x, i.rt.y, i.rt.x, o.rt.y+c);
			lineTo(i.rd.x, o.rd.y-c);
			quadraticCurveTo(i.rd.x, i.rd.y, o.rd.x-c, i.rd.y);
			lineTo(o.ld.x+c, i.ld.y);
			quadraticCurveTo(i.ld.x, i.ld.y, i.ld.x, o.ld.y-c);
			closePath();
			fill();
		};
	},
	drawBox : function() {
		this.clear();
		this.opacity = 0.7;
		text = this.node.getStatusForDisplay();
		this.reDraw();
		with(this.image.context) {
			fillStyle = 'black';
			textAlign = 'center';
			textBaseline = 'middle';
			var textList = text.split("\n");
			var len = textList.length / 2;
			var height = (this.height/(1 + len));
			this.fillTextLine(text,this.width/2, height);
		}
	},
	fillTextLine : function(text, x, y) {
		var textList = text.split("\n");
		var lineHeight = this.image.context.measureText("あ").width + 2;
		var self = this;
		textList.forEach(function(text, i) {
			self.image.context.fillText(text, x, y + lineHeight * i);
		});
	},
	getX : function(){
		return this.x;
	},
	getY : function(){
		return this.y;
	},
	getWidth: function(){
		return this.width;
	},
	getHeight: function(){
		return this.height;
	},
	touchstart:function(self){
		return function(e){
			if(typeof e === "undefined")return;
			// this.removeEventListener('touchstart', arguments.callee);
			// self.release();
			// if(self.x <= e.x && self.x + self.width >= e.x
			// 	&& self.y <= e.y && self.y + self.height >= e.y
			// 	){
			if(ctl.isCollision(e, self)){
				this.removeEventListener('touchstart', arguments.callee);
				self.release();
			}

		};
	},
	release: function(){
		this.parentNode.removeChild(this);
		ctl.backgroundMap.removeChild(this);
		ctl.removeObj(this);
		this.lifetime = null;
		this.ctl = null;
	}

});


GPopup = enchant.Class.create(enchant.Sprite, {
	initialize : function(scene, x, y, w, h) {
		enchant.Sprite.call(this, w, h);
		this.image = new Surface(w, h);
		this.x = x;
		this.y = y;
		scene.addChild(this);
		this.scene = scene;
		this.text = "";
	},
	clear : function() {
		this.image.context.fillStyle = '#000099';
		this.image.context.fillRect(0, 0, this.getWidth(), this.getHeight());
	},
	setText : function(text) {
		this.image.context.fillStyle = 'black';
		this.image.context.textAlign = 'left';
		this.image.context.textBaseline = 'top';
		this.image.context.font = "13px 'Times New Roman'";

		var textWidth = Math.floor(this.image.context.measureText(text).width);
		var lineHeight = this.image.context.measureText("あ").width;
		var _textList = text.split("\n");
		this.renew(this.scene, this.x, this.y, textWidth, (lineHeight) * _textList.length + 6);
		this.text = text;
	},
	drawText : function (){
		this.clear();
		var x = 0;
		var y = 0;
		// var lineHeight = this.image.context.measureText("あ").width;
		this.image.context.fillStyle = '#ffffff';
		this.image.context.textAlign = 'left';
		this.image.context.textBaseline = 'alphabetic';
		this.image.context.font = "12px 'Times New Roman'";
		this.fillTextLine(this.text ,x, y);
	},
	getWidth : function(){
		return this.image.width;
	},
	getHeight : function(){
		return this.image.height;
	},
	fillTextLine : function(text, x, y) {
		var textList = text.split("\n");
		var lineHeight = this.image.context.measureText("あ").width + 2;
		var self = this;
		textList.forEach(function(text, i) {
			self.image.context.fillText(text, x, y + lineHeight * (i+1));
		});
	},
	renew : function(scene, x, y, w, h){
		scene.removeChild(this);
		enchant.Sprite.call(this, w, h);
		this.image = new Surface(w, h);
		this.x = x;
		this.y = y;
		scene.addChild(this);
	}
});


GWindow = enchant.Class.create(enchant.Sprite, {
	initialize : function(scene, x, y, w, h) {
		enchant.Sprite.call(this, w, h);
		this.image = new Surface(w, h);
		this.x = x;
		this.y = y;
		scene.addChild(this);
	},
	clear : function() {
		this.image.context.fillStyle = '#ffff00';
		this.image.context.fillRect(0, 0, this.getWidth(), this.getHeight());
	},
	text : function(text, x, y) {
		this.clear();
		this.image.context.fillStyle = 'black';
		this.image.context.textAlign = 'left';
		this.image.context.textBaseline = 'middle';
		this.image.context.font = "12px 'Times New Roman'";
		var textWidth = Math.floor(this.image.context.measureText(text).width);

		var lineHeight = this.image.context.measureText("あ").width;
		this.image.context.fillText(text + ":" + textWidth,x, y + lineHeight);
	},
	getWidth : function(){
		return this.image.width;
	},
	getHeight : function(){
		return this.image.height;
	},

	renew : function(scene, x, y, w, h){
		scene.removeChild(this);
		enchant.Sprite.call(this, w, h);
		this.image = new Surface(w, h);
		this.x = x;
		this.y = y;
		scene.addChild(this);
	}
});


//how to use
//var tweet = new TTweet(128, 64);
//tweet.text("ABCDEFG");